package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.MakeTagCacheService;
import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class RefreshMakeTagCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private MakeTagCacheService makeTagCacheService;
    @Override
    public String getListenTag() {
        return "makeTagMessageTag";
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            makeTagCacheService.refreshMakeTag(message);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
