package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertPromoteTestCacheService;
import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.duiba.tuia.tool.StringTool;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**刷新素材ID对应测试落地页缓存
 * Created by jzl on 18/5/10.
 */
@Component
public class RefreshMaterialPromoteTestCacheHandler extends AbstractMessageResultHandler {
    @Autowired
    private MediaCacheService mediaCacheService;

    @Autowired
    private AdvertPromoteTestCacheService advertPromoteTestCacheService;


    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC129.toString();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {

            //message格式为:"materialId,advertId"
            logger.info("Topic:{},Msg:{}", getListenTag(), message);

            List<Long> longListByStr = StringTool.getLongListByStr(message);

            //上线兼容
            if (longListByStr.size() < 2) {
                mediaCacheService.updateMaterialPromoteTest(longListByStr.get(0));
            } else {
                advertPromoteTestCacheService.updateMaterialPromoteTest(longListByStr.get(0), longListByStr.get(1));
            }


        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
