package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.SlotWhiteListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RefreshMediaSLotListHandler extends AbstractMessageResultHandler {


    @Autowired
    private SlotWhiteListService slotWhiteListService;

    /**
     * 广告位黑白名单
     */
    public static final String TAG_MEDIA_SLOT_LIST = "tagMediaSlotList";

    public static final String SPLIT_FLAG = ",";


    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return TAG_MEDIA_SLOT_LIST;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag="+TAG_MEDIA_SLOT_LIST+",msg="+message);
        try {
            if(!StringUtils.isEmpty(message)){
                String[] split_flags = message.split(SPLIT_FLAG);
                for (int i = 0; i < split_flags.length; i++) {
                    try {
                        slotWhiteListService.updateMediaList(Long.valueOf(split_flags[i]));
                    } catch (NumberFormatException e) {
                        logger.error("传参有问题",e);
                        continue;
                    }
                }
            }
        } catch (Exception e) {
            logger.error("消息处理失败",e);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }

}
