package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.SlotWhiteListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RefreshMediaSlotOpenStatusHandler extends AbstractMessageResultHandler {


    /**
     * 广告黑白名单 开关状态
     */
    public static final String TAG_MEDIA_SLOT_OPEN_STATUS = "tagMediaSlotListOpenStatus";


    @Autowired
    private SlotWhiteListService slotWhiteListService;


    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return TAG_MEDIA_SLOT_OPEN_STATUS;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag="+TAG_MEDIA_SLOT_OPEN_STATUS+",msg="+message);
        try {
            slotWhiteListService.updateMediaOpenStatus(Long.valueOf(message));
        } catch (NumberFormatException e) {
            logger.error("消息处理失败",e);
        }
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
