package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.NewAppTestCacheService;
import cn.com.duiba.tuia.domain.model.UpdateNewAppTestCacheMsg;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 新媒体试投缓存更新消息
 */
@Component
public class RefreshNewAppTestCacheMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private NewAppTestCacheService newAppTestCacheService;

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_NEW_APP_TEST_CACHE_MSG;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + ConfigRocketMqTags.UPDATE_NEW_APP_TEST_CACHE_MSG + ",msg="+message);

        try {
            UpdateNewAppTestCacheMsg msgObj = JSONObject.parseObject(message, UpdateNewAppTestCacheMsg.class);

            if (msgObj.getAppId() == null || msgObj.getType() == null) {
                logger.warn("媒体或type为空的情况下,message:{}", message);
                return;
            }
            switch (msgObj.getType()) {
                case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_IDS_CACHE:
                    newAppTestCacheService.newAppIdsCacheRefresh();
                    break;
                case UpdateNewAppTestCacheMsg.TYPE_APP_TEST_TO_ADVERT_CACHE:
                    break;
                case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_NOT_TEST_TRADE_CACHE:
                    newAppTestCacheService.newAppNotTestTradeCacheRefresh(msgObj.getAppId());
                    break;
                case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_NOT_TEST_ADVERT_CACHE:
                    newAppTestCacheService.newAppNotTestAdvertCacheRefresh(msgObj.getAppId());
                    break;
                case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE:
                    newAppTestCacheService.allTestAdvertCacheRefresh();
                    break;
                case UpdateNewAppTestCacheMsg.TYPE_NEW_APP_TEST_ALL_ADVERT_CACHE_OTHER:
                    newAppTestCacheService.appTestToAdvertCacheRefresh(msgObj.getAdvertId());
                    break;
                default:
                    break;
            }
        } catch (Exception e) {
            logger.error("RefreshNewAppTestCacheMsgHandler msg error msg[{}],exception:{}", message, e);
        }
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
