package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.OrderCustomAdvertService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 刷新券次序定制广告缓存消息
 */
@Component
public class RefreshOrderCustomCacheMsgHandler extends AbstractMessageResultHandler {

    @Resource
    private OrderCustomAdvertService orderCustomAdvertService;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ORDER_CUSTOM_CACHE;
    }

    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + getListenTag() + ",msg="+message);

        if (StringUtils.isNumeric(message)) {
            orderCustomAdvertService.refreshCache(Long.valueOf(message));
            logger.info("success，tag=" + getListenTag() + ",msg="+message);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
