package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.AdvertPeriodService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author huangruodan
 * @version 创建时间：2020/10/15 2:54 下午
 */
@Component
public class RefreshPeriodsCacheMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertPeriodService advertPeriodService;

    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_ADVERT_PERIOD;
    }

    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + getListenTag() + ",msg="+message);

        List<Long> periods = JSON.parseArray(message, Long.class);
        try {
            advertPeriodService.invalidPeriodCache(periods);
        } catch (Exception e) {
            logger.error("RefreshPeriodsCacheMsgHandler msg error msg[{}],exception:{}", message, e);
        }
        logger.info("success，tag=" + getListenTag() + ",msg="+message);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
