package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.AppPrivilegeService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 更新特权媒体库
 */
@Component
public class RefreshPrivilegeAppMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AppPrivilegeService appPrivilegeService;

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_PRIVILEGE_APP_MSG;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + ConfigRocketMqTags.UPDATE_PRIVILEGE_APP_MSG + ",msg="+message);

        try {
            //更新特权媒体库
            appPrivilegeService.updateAppPrivilege();
        } catch (Exception e) {
            logger.error("RefreshPrivilegeAppMsgHandler msg error msg[{}],exception:{}", message, e);
        }
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
