package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertMapCacheManager;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 刷新转化类型联动配置缓存
 * Created by lijian on 20210202.
 */
@Component
public class RefreshPutLinkageConfigMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertMapCacheManager advertMapCacheManager;

    @Override
    public String getListenTag() {
        return "updatePutLinkageConfigMsg";
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isBlank(message)) {
            return;
        }
        logger.info("Topic:{},Msg:{}", getListenTag(), message);
        try {
            advertMapCacheManager.refreshPutLinkageConfig(message);

        } catch (Exception e) {
            logger.error("updatePutLinkageConfigCache error, newTrade=[{}],", message, e);

        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
