package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.RTAService;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 刷新广告缓存消息
 */
@Component
public class RefreshRTAAdvertExpandCacheHandler extends AbstractMessageResultHandler {

    @Autowired
    private RTAService rtaService;

    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC149.toString();
    }

    @Override
    public void consumer(String message) {
        logger.info("Topic:{},Msg:{}",getListenTag(),message);
        if (StringUtils.isBlank(message)) {
            return;
        }
        Long appId = Long.valueOf(message);
        rtaService.refreshAdvertExpandCache(appId);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
