package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author:zhangmeng
 * @Date:2018/9/4
 * @Function:
 */
@Component
public class RefreshRiskAdvertHandler extends AbstractMessageResultHandler{

    @Autowired
    private SystemConfigDAO systemConfigDAO;
    @Override
    public String getListenTag() {
        return SystemConfigKeyConstant.RISK_CHEAT_ADVERT;
    }

    @Override
    public void consumer(String message) {
        try{
            if (StringUtils.isNotBlank(message)) {
                AdvertSystemConfigureConstants.riskAdvertId = String.valueOf(message);
                logger.info("riskAdvert:{}",AdvertSystemConfigureConstants.riskAdvertId);
            }
        }catch (Exception e){
            logger.error("获取风控作弊流量测试广告异常！");
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
