package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.constants.AdvertSystemConfigureConstants;
import cn.com.duiba.tuia.dao.engine.SystemConfigDAO;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Author:zhangmeng
 * @Date:2018/9/4
 * @Function:
 */
@Component
public class RefreshRiskPercentHandler extends AbstractMessageResultHandler{

    @Autowired
    private SystemConfigDAO systemConfigDAO;

    @Override
    public String getListenTag() {
        return SystemConfigKeyConstant.RISK_CHEAT_PERCENT;
    }

    @Override
    public void consumer(String message) {
        try{
            if (StringUtils.isNotBlank(message)) {
                AdvertSystemConfigureConstants.riskPercent = String.valueOf(message);
                logger.info("riskPercent:{}",AdvertSystemConfigureConstants.riskPercent);
            }
        }catch (Exception e){
            logger.error("获取风控作弊流量切量比例异常！");
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
