package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.AdvertPackageAppAdjustFeeCacheService;
import cn.com.tuia.advert.constants.ConfigRocketMqTags;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.util.List;

/**
 * 后端签收数据 缓存更新消息
 */
@Component
public class RefreshSignCacheMsgHandler extends AbstractMessageResultHandler {

    @Autowired
    private AdvertPackageAppAdjustFeeCacheService adjustFeeCacheService;

    /**
     * 获取消费tag
     * getListenTag:(这里用一句话描述这个方法的作用). <br/>
     *
     * @return
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public String getListenTag() {
        return ConfigRocketMqTags.UPDATE_SIGN_CACHE_MSG;
    }

    /**
     * 消费消息
     *
     * @param message
     * @author zf
     * @since JDK 1.6
     */
    @Override
    public void consumer(String message) {
        logger.info("接收到消息，tag=" + ConfigRocketMqTags.UPDATE_SIGN_CACHE_MSG + ",msg="+message);

        try {
            List<String> keys = JSON.parseArray(message, String.class);
            if (CollectionUtils.isNotEmpty(keys)) {
                keys.forEach(key -> adjustFeeCacheService.invalidateAdjustFee(key));
            }
        } catch (Exception e) {
            logger.error("RefreshSignCacheMsgHandler msg error msg[{}],exception:{}", message, e);
        }
    }

    /**
     * Invoked by the containing {@code BeanFactory} after it has set all bean properties
     * and satisfied {@link BeanFactoryAware}, {@code ApplicationContextAware} etc.
     * <p>This method allows the bean instance to perform validation of its overall
     * configuration and final initialization when all bean properties have been set.
     *
     * @throws Exception in the event of misconfiguration (such as failure to set an
     *                   essential property) or if initialization fails for any other reason
     */
    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
