package cn.com.duiba.tuia.message.rocketmq.listener;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.com.duiba.tuia.api.TuiaMediaClientService;
import cn.com.duiba.tuia.ssp.center.api.constant.RedisKeyConstant;
import cn.com.duiba.tuia.ssp.center.api.dto.StrategyCacheDto;

import com.alibaba.fastjson.JSON;


@Component
public class RefreshSlotStrategyCacheHandler extends AbstractMessageResultHandler {


    @Autowired
    private TuiaMediaClientService tuiaMediaClientService;
    @Override
    public String getListenTag() {
        return RedisKeyConstant.getSlotShieldStrategyKey();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            tuiaMediaClientService.updateSlotStrategy(JSON.parseObject(message, StrategyCacheDto.class).getSlotId());
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
