package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.MediaCacheService;
import cn.com.tuia.advert.cache.RedisCommonKeys;

import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**广告位白名单缓存刷新
 * Created by jzl on 18/4/18.
 */
@Component
public class RefreshSlotWhiteListCacheHandler extends AbstractMessageResultHandler {

    @Autowired
    private MediaCacheService mediaCacheService;

    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC127.toString();
    }

    @Override
    public void consumer(String message) {
        if (StringUtils.isNotBlank(message)) {
            logger.info("Topic:{},Msg:{}",getListenTag(),message);
            mediaCacheService.updateSlotWhiteList(Long.valueOf(message));
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        //在消息处理器中注册
        RocketMqMessageListener.registerCallback(this);
    }
}
