package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.tuia.advert.cache.RedisCommonKeys;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Map;

/**
 * xuxx:20190529
 *
 */

@Component
public class RefreshUrgentAdvertCacheHandler extends AbstractMessageResultHandler{

    @Autowired
    private ServiceManager serviceManager;

    @Override
    public String getListenTag() {
        return RedisCommonKeys.KC138.toString();
    }

    @Override
    public void consumer(String message) {
        logger.info("Topic:{},Msg:{}",getListenTag(),message);
        Map<String,Boolean> statusMap = (Map<String, Boolean>) JSON.parse(message);
        serviceManager.updateUrgentAdvertStatus(statusMap);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
