package cn.com.duiba.tuia.message.rocketmq.listener;

import cn.com.duiba.tuia.service.filter.AutoFlowbackFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RemoveFlowbackWhiteListHandler extends AbstractMessageResultHandler {

    @Autowired
    private AutoFlowbackFilter autoFlowbackFilter;

    @Override
    public String getListenTag() {
        return "flowbackRemove";
    }


    @Override
    public void consumer(String message) {
        logger.info("Topic:{},Msg:{}",getListenTag(),message);
        if (StringUtils.hasText(message)) {
            autoFlowbackFilter.rmCache(message);
        }
    }


    @Override
    public void afterPropertiesSet() throws Exception {
        RocketMqMessageListener.registerCallback(this);
    }
}
