package cn.com.duiba.tuia.remoteservice.engine.impl;

import cn.com.duiba.tuia.adx.meituan.MeituanAdxService;
import cn.com.duiba.tuia.service.BaseService;
import cn.com.duiba.tuia.standardscene.scene.AdxServiceScene;
import cn.com.tuia.advert.model.AdxLogReq;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.service.IAdxService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Primary
public class RemoteAdxServiceImp extends BaseService implements IAdxService {


    @Autowired
    private AdxServiceScene adxServiceScene;

    @Autowired
    private MeituanAdxService meituanAdxService;

    /**
     * 活动预发券请求, act-web调用80ms熔断
     *
     * @param req req#adxLoadType，1：预发券
     *            req#adxMediaType，1：互动直投API
     * @return
     * @fallback 降级处理，请做好兼容
     */
    @Override
    public ObtainAdvertRsp actPreLoadAdvert(ObtainAdvertReq req) {
        // 添加活动预发券标志 actPreType
        req.setActPre(Boolean.TRUE);
        return adxServiceScene.loadAdvert(req);
    }

    /**
     * adx预发券请求（tuia-engine用）
     * <p>
     * 当请求是美团adx时，我方作为dsp返回广告券的同时将记录发券订单等数据
     *
     * @param req req#adxLoadType，1：预发券
     * @return
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#preLoadAdvert}
     */
    @Override
    public ObtainAdvertRsp preLoadAdvert(ObtainAdvertReq req) {
        return adxServiceScene.loadAdvert(req);
    }

    /**
     * adx真实发券请求(tuia-engine用)
     *
     * @param req req#adxLoadType 2：真实发券
     * @return
     * @fallback 降级处理，请做好兼容 {@link IAdxServiceFallbackImpl#actLoadAdvert}
     */
    @Override
    public ObtainAdvertRsp actLoadAdvert(ObtainAdvertReq req) {
        return adxServiceScene.loadAdvert(req);
    }

    /**
     * 日志补偿
     * <p>
     * 1、美团adx请求发券时，我方作为dsp返回广告券：请求 IAdxService#preLoadAdvert 接口返回预出的广告券
     * 2、当在美团adx成功竞价，广告券曝光时，将调用此接口进行日志补偿，将会对以下日志进行补偿：
     * a、请求日志
     * b、发券日志
     * c、曝光日志
     * 3、追加领券记录及时段发券量
     * 3、点击及计费日志走原有的逻辑，详情：{@link ISpmService#clickLog(SpmlogReq)}
     *
     * @param req 请求参数
     * @return 日志补偿是否成功
     */
    @Override
    public boolean reLog(AdxLogReq req) {
        return  meituanAdxService.reLog(req);
    }
}
