package cn.com.duiba.tuia.repository;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import com.netflix.hystrix.contrib.javanica.annotation.DefaultProperties;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;

import com.netflix.hystrix.contrib.javanica.conf.HystrixPropertiesManager;
import cn.com.duiba.tuia.domain.model.DeviceInstallApps;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2018年01月09日 19:48
 * @descript: 获取用户安装的app列表
 * @version: 1.0
 */
@DefaultProperties(groupKey = "Engine", threadPoolKey = "QueryDeviceInstallAppsRepository",
        threadPoolProperties = {
            @HystrixProperty(name = HystrixPropertiesManager.CORE_SIZE, value = "20"),
            @HystrixProperty(name = HystrixPropertiesManager.MAX_QUEUE_SIZE, value = "20")
        },
        commandProperties = {@HystrixProperty(name = HystrixPropertiesManager.EXECUTION_ISOLATION_THREAD_TIMEOUT_IN_MILLISECONDS, value = "200")})
@Repository
public class QueryDeviceInstallAppsRepository implements ApplicationContextAware {

    private static final Logger logger = LoggerFactory.getLogger(QueryDeviceInstallAppsRepository.class);

    private final String DEVICEID_FIELD = "_id";

    private final String APP_INSTALL_COLLECTION = "device_install";

    private final DeviceInstallApps empty = new DeviceInstallApps();

    private ApplicationContext applicationContext;

    @HystrixCommand(commandKey = "DeviceInstall", fallbackMethod = "fallback")
    public DeviceInstallApps getDeviceInstall(String deviceId) {

        MongoTemplate mongoTemplate = (MongoTemplate) applicationContext.getBean("mongoTemplate");
        if (mongoTemplate == null) {
            throw new RuntimeException("mongoTemplate 没有初始化");
        }

        return mongoTemplate.findOne(Query.query(Criteria.where(DEVICEID_FIELD).is(deviceId)), DeviceInstallApps.class,
                APP_INSTALL_COLLECTION);
    }

    public DeviceInstallApps fallback(String deviceId, Throwable e) {
        logger.info("QueryDeviceInstallAppsRepository Error,设备ID：{}", deviceId, e);
        return empty;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

}
