package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.AdvertOrderExtDO;
import cn.com.duiba.tuia.domain.dataobject.AdxAdvertMaterialDO;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.domain.vo.AdxAdvertPriceVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.exception.ReadableMessageException;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;
import cn.com.tuia.advert.model.QueryAdvertRsp;
import cn.com.tuia.advert.model.SpmlogReq;
import cn.com.tuia.advert.model.dsp.AdxAdvertPriceDto;

/**
 * Created by hujinliang on 2017/8/14.
 */
public interface AdvertExposeService {
    /**
     * 推荐系统确定一个广告ID之后，进行发券流程，并且返回构造结果. <br/>
     *
     * @param advertId
     * @param advertVO
     * @return
     * @throws TuiaException
     * @advertPriceVO warn: advertPriceVO不能为NULL，如果为NULL不可能到这里
     * @aFee 实际出价，只有nazha推荐的广告才会有目标出价
     * @author sunjiangrong
     * @since JDK 1.6
     */
    ObtainAdvertRsp finishBiz(ObtainAdvertReq req, ObtainAdvertRsp rsp, Long advertId, AdvertVO advertVO,
                              FilterResult filterResult, AdvertPriceVO advertPriceVO, Long aFee, AdvertFilter advertFilter) throws TuiaException;

    /**
     * 推荐系统确定一个广告ID之后，进行发券流程，并且返回构造结果. <br/>
     *
     * @param req
     * @param adxAdvert
     * @return
     * @throws TuiaException
     * @advertPriceVO warn: advertPriceVO不能为NULL，如果为NULL不可能到这里
     * @aFee 实际出价，只有nazha推荐的广告才会有目标出价
     * @author lijian
     * @since JDK 1.8
     */

    ObtainAdvertRsp finishBizForDsp(ObtainAdvertReq req, ObtainAdvertRsp rsp, AdxAdvertMaterialDO adxAdvert,
                                    FilterResult filterResult, AdxAdvertPriceVO adxAdvertPrice) throws TuiaException;

    /**
     * dsp广告订单保存
     *
     * @param advertOrderDO
     * @return the query advert rsp
     * @throws ReadableMessageException the readable message exception
     */
    void insertDspAdvertOrder(AdvertOrderDO advertOrderDO, AdvertOrderExtDO orderExtDO) throws ReadableMessageException;

    /**
     * dsp-engine 发券日志补打
     * @param req
     * @param rsp
     * @param adxAdvertPrice
     */
    void dspLaunchLog(ObtainAdvertReq req,ObtainAdvertRsp rsp,AdxAdvertPriceDto adxAdvertPrice);


    /**
     * 互动广告补打发券日志
     * @param req
     */
    void  reLog(SpmlogReq req);

}
