package cn.com.duiba.tuia.service;

/**
 * Created by huangch on 2018/1/3 19:10
 * description:
 *
 * @since JDK 1.6
 */
public interface AdvertInvalidHandleService {

    /**
     * 发送配置包预算不足消息
     *
     * @param advertId 广告id
     * @param pkgId    配置包id
     * @param curDate  当前时间
     */
    void sendBudgetNotEnoughDingNotice(Long advertId, Long pkgId, String curDate);

    /**
     * 发送广告无效的消息
     *
     * @param advertId    广告id
     * @param validStatus 广告无效类型
     */
    void publishInvalidAdvertMsg(Long advertId, Integer validStatus);
}
