package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Set;

import cn.com.duiba.tuia.domain.dataobject.AdvertMaterialDto;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.tuia.advert.model.ObtainAdvertReq;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年07月11日 09:37
 * @descript: 素材推荐
 * @version: 1.0
 */
public interface AdvertMaterialRecommendService {

    /**
     * 初始化有效广告的素材
     * @param validAdvertIds
     */
    void init(List<Long> validAdvertIds);

    /**
     * 获取素材ID
     * @return
     */
    Set<Long> getMaterialsByAdvertId(Long advertId);

    /**
     * 获取广告默认素材ID
     * @param advertId
     * @return
     */
    Long getDefaultByAdvertId(Long advertId);

    List<Long> getReceiveMaterial(List<ConsumerInteractiveRecordDO> consumerVOS );

    Set<Long> filterByAdvertId(Long advertId, Long accountId, AdvQueryParam advQueryParam);
    
    Set<Long> getMaterialSetByAdvertId(Long advertId);
    
    List<AdvertMaterialDto> getMaterialListByAdvertId(Long advertId);

    Set<Long> filterByActivityType(Integer activityMaterialType,Long advertId, Set<Long> alreadyMaterials);

    Long getWindId(Long advertId,Long materialId);

    Set<Long> filterBySlotId(AdvQueryParam advQueryParam, Set<Long> materialIds, Long advertId, ObtainAdvertReq req);

    Set<Long> filterNewTradeBySlotId(AdvQueryParam advQueryParam, Set<Long> materialIds, Long advertId, ObtainAdvertReq req);

    Set<Long> filterByMaterialType(Set<Long> materialIds, Long advertId, AdvQueryParam advQueryParam, ObtainAdvertReq req);

    Set<Long> getAdvertVideoMaterialSet(Long advertId);
}
