package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrientationPackageDO;
import cn.com.duiba.tuia.domain.dataobject.OrientationFocusAppConvertCostDO;
import cn.com.duiba.tuia.domain.model.AdvertOrientationPackageDto;
import cn.com.duiba.tuia.domain.vo.AdvertOrientationPackageVO;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年03月29日 11:19
 * @descript: 广告定向配置包
 * @version: 1.0
 */
public interface AdvertOrientationService {

    /**
     * 根据配置ID获取定向配置
     * @param id
     * @return
     */
    AdvertOrientationPackageDO getOrientation(Long id);

    /**
     * 更新广告的定向配置
     * @param orientationId
     */
    void updateOrientation(AdvertOrientationPackageDO orientationPackageDO);

    /**
     * 更新广告的默认定向配置
     * @param advertId
     */
    void updateDefaultOrientation(Long advertId);

    /**
     * 根据广告Id获取所有的定向配置包括默认配置以及投放时段
     * @param advertId
     * @return
     */
    List<AdvertOrientationPackageVO> getOrientationList(Long advertId);

    /**
     * 初始化定向配置列表
     * @param advertIdList
     */
    void initAdvertOrirntationList(List<Long> advertIdList);


    /**
     * 根据广告列表批量获取定向配置
     *
     * @param advertIds
     * @return
     */
    List<AdvertOrientationPackageDO> getOrientationList(List<Long> advertIds);


    /**
     * 据广告id和定向包id组合查询，后者为0的话则查询广告的默认配置包
     * @param advertId
     * @param orientationPackageId
     * @return
     */
    AdvertOrientationPackageDto  getOrientation(Long advertId, Long orientationPackageId);

    /**
     * 
     * checkUserInterest:(校验人群兴趣点命中). <br/>
     *
     * @author chencheng
     * @param userInterest
     * @param userInterest2
     * @return
     * @since JDK 1.8
     */
    Boolean checkUserInterest(Set<String> userInterest, List<String> userInterest2);

    /**
     * 
     * getOrientationPackages:(从数据库获取广告下配置). <br/>
     *
     * @author chencheng
     * @param advertId
     * @return
     * @since JDK 1.8
     */
    List<AdvertOrientationPackageVO> getOrientationPackagesByDB(Long advertId);

    /**
     * 
     * getAdvertTradeAccept:(获取配置包的人群兴趣配置). <br/>
     *
     * @author chencheng
     * @param advtags
     * @param tradeAccept
     * @param crowdInterest
     * @param crowdTradePackageTag
     * @return
     * @since JDK 1.8
     */
    /*Set<String> getAdvertTradeAccept(Set<String> advtags, String tradeAccept, String crowdInterest, String crowdTradePackageTag,String systemRecommendTag);*/


    /**
     * 获取配置包人群兴趣配置
     * @param advtags
     * @param tradeAccept
     * @return
     */
    List<String> getAdvertTradeAccept(Set<String> advtags, List<String> tradeAccept);

    /**
     * 根据定向配置获取 配置的落地页链接
     * @return
     */
    String getOrientPromoteUrl(Long orientId);
}
