package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.tuia.core.api.enums.advert.AdvertPkgPeriodTypeEnum;
import cn.com.duiba.tuia.domain.dataobject.AdvertPlanPeriodDO;
import cn.com.duiba.tuia.exception.TuiaException;

import com.alibaba.fastjson.JSONArray;


/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年04月06日 16:17
 * @descript:
 * @version: 1.0
 */
public interface AdvertPeriodService {

    void setAdvertPeriodPut(String key, Boolean isPut);

    Boolean getAdvertPeriodPut(Long periodId,String periodType);

    /**
     * 获取时段map key <br/>
     * 如果类型为（总预算/总发券量）key = periodId + periodType + 2017-07-20
     * 如果类型为（每小时预算/每小时发券量）key = periodId + periodType + 2017-07-20 07。 时间维度"小时"
     *
     * @param periodId 投放时段id
     * @param typeEnum 投放时段类型
     * @param curPeriodTime 当天时间投放时段消耗时间
     * @return
     */
    String getPeriodPutKey(Long periodId, AdvertPkgPeriodTypeEnum typeEnum);

    /**
     * 添加投放时段（发券量）和 更新当前时段是否有效缓存
     * @param periodId
     * @param periodValue
     * @param periodType
     * @throws TuiaException
     */
    void addPeriodCountAndEditCache(Long periodId,Long periodValue,String periodType) throws TuiaException;

    /**
     *
     * @param periodType 时段类型
     * @param curPeriodTime 当天时间投放时段消耗时间 类型为(每小时发券量/每小时预算),日期格式 2017-07-21 10,类型为(总发券量/总预算),日期格式 2017-07-21
     * @return
     */
    String getCurPeriodTime(String periodType);

    /**
     * 从缓存获取时段值
     * @author zp
     * @param periodId
     * @return
     * @since JDK 1.6
     */
    AdvertPlanPeriodDO getPeriodCacheById(Long periodId);


    /**
     * 失效时段的缓存
     * @param periodIds
     */
    void invalidPeriodCache(List<Long> periodIds);

    /**
     *
     * buildPeriodList:组装投放时段
     *
     * @param periodArr
     * @param advertId
     * @param orientId
     * @return
     * @since JDK 1.8
     */
    List<AdvertPlanPeriodDO> buildPeriodList(JSONArray periodArr, Long advertId, Long orientId);

    /**
     *
     * initPeriodCache:(项目启动初始化有效广告配置时段缓存). <br/>
     *
     * @author chencheng
     * @param adevrtIds
     * @since JDK 1.8
     */
    void initPeriodCache(List<Long> advertIds);

    /**
     *
     * getTheAdvertPeriodPut:(查询全局变量的值). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    Map<String, Boolean> getTheAdvertPeriodPut();

}
