package cn.com.duiba.tuia.service;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.online.service.api.dto.DeviceFilterDto;
import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.model.*;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

import java.util.List;
import java.util.Map;

/**
 * Created by hujinliang on 2017/8/11.
 */

public interface AdvertPreFilterService {
    /**
     * 组装查询参数
     * @param cityId
     * @param advQueryParam
     *
     * @param req
     * @param shieldStrategyVO
     * @param consumerVOList
     * @param receiveAdvertIds
     * @param consumerDto
     * @param filterResult
     * @return
     * @throws TuiaException
     */
    AdvQueryParam buildAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, ObtainAdvertRsp rsp, ShieldStrategyVO shieldStrategyVO,
                                     List<ConsumerInteractiveRecordDO> consumerVOList, List<Long> receiveAdvertIds, ConsumerDto consumerDto, FilterResult filterResult, DeviceTagDto deviceTagDto, Map<String,String> newUserDmpTagsMap) throws Throwable;

    AdvQueryParam secondBuildAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, FilterResult filterResult) throws TuiaException;

    /**
     * 组装参数（没有用户记录）
     *
     * @param req
     * @param shieldStrategyVO
     * @param cityId
     * @return
     * @throws TuiaException
     */
    AdvQueryParam buildDirectAdvQueryParam(AdvQueryParam advQueryParam, ObtainAdvertReq req, ShieldStrategyVO shieldStrategyVO) throws TuiaException,
        Exception;

    /**
     * 时段，app，日预算过滤,素材标签过滤
     * @param advQueryParam
     * @param req
     * @param filterResult
     * @param advertFilter
     * @return
     */
    Map<Long, AdvertFilterVO> preFilterAdvertWithEsHystrix(AdvQueryParam advQueryParam, ObtainAdvertReq req,
        FilterResult filterResult, AdvertFilter advertFilter);


    /**
     * 时段，app，日预算过滤
     * @param advQueryParam
     * @param req
     * @param advertFilter
     * @return
     */
    List<AdvOrientationItem> directAdvertOrientationWithEsHystrix(AdvQueryParam advQueryParam, ObtainAdvertReq req,
        FilterResult filterResult, AdvertFilter advertFilter);

    void setMatchTradePackageTag(List<AdvOrientationItem> filterAdv, FilterResult filterResult, AdvQueryParam advQueryParam);

    /**
     * 将过滤后得到的候选 配置 放入广告中
     * @param filterAdv
     * @param advQueryParam
     * @param req
     * @param filterResult
     * @return
     */
    Map<Long, AdvertFilterVO> storeOrientationPrice(List<AdvOrientationItem> filterAdv, AdvQueryParam advQueryParam,
                                                    ObtainAdvertReq req, FilterResult filterResult);

    Integer getCanReplaceLowArpuStatus(AdvQueryParam advQueryParam, Long accountId, Long advertId);

    /**
     * 获取dmp数据
     * @param deviceId
     * @param activityPriorityCondition 经纬度条件
     * @return
     */
    DeviceTagDto getDmpTagData(String deviceId, boolean activityPriorityCondition);

    /**
     * 获取设备已转化数据
     * @param deviceId
     * @return
     */
    DeviceFilterDto getDeviceFilterDto(String deviceId);
}
