package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by hujinliang on 2017/8/14.
 */
public interface AdvertQueryService {

    Map<String, List<AdvOrientationItem>> advertMemoryFilter(AdvQueryParam advQueryParam, AdvertFilter advertFilter, FilterResult filterResult, ObtainAdvertReq req);

    /**
     * 互选过滤
     *
     * @param advQueryParam
     * @param advertId
     * @param advertVO
     * @return
     */
    boolean appSelectAdvertCheck(AdvQueryParam advQueryParam, Set<Long> leftMaterial, Long advertId, AdvertVO advertVO);


    /**
     * 大盘主要场景 内存过滤代码
     * @return
     */
    List<AdvOrientationItem> advertMemoryFilterMainScene(AdvQueryParam advQueryParam, AdvertFilter advertFilter, FilterResult filterResult, ObtainAdvertReq req);


}
