package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.NewAppTest;

import java.util.List;


/**
 * Created by lizhihui on 2017-06-27 11:57.
 */
public interface AdvertRealDataService {
    void incrExposureAdvert(Long agentId, Long accountId, Long advertId, Long advertPlanId, Integer effectiveMainType);

    void incrClickAdvert(Long agentId, Long accountId, Long advertId,Long advertPlanId, Integer effectiveMainType, NewAppTest newAppTest);

    void incrLaunchAdvert(Long agentId, Long accountId, Long advertId, Long advertPlanId,Integer effectiveMainType,NewAppTest newAppTest, Long appId, Integer supportStatus);

    Long incrTuiaAdvertConsumeFee(Long advertId,Long fee);

    Long incrTuiaAccountConsumeFee(Long accountId,Long fee);

    boolean appSupportLaunchCheck(Long advertId, Long appId);

    /**
     * 记录账户扣钱记录
     * @param accountId
     * @param fee
     * @return
     */
    Long incrTuiaAccountBalance(Long accountId,Long fee);

    /**
     * 
     * getAdvertLaunch:(获取广告发券量). <br/>
     *
     * @author chencheng
     * @param advertId
     * @return
     * @since JDK 1.8
     */
    Long getAdvertLaunch(Long agentId, Long accountId, Long advertId,Long advertPlandId);

    /**
     * 
     * getNewAppDayLaunch:(新媒体测试发券). <br/>
     *
     * @author chencheng
     * @param key
     * @return
     * @since JDK 1.8
     */
    List<Long> getNewAppDayLaunch(Long key);

    Object getAppDailyLaunchCount(String appDailyLaunchKey, String hashKey);

    Object getAppSupportDailyLaunchCount(String appSupportDailyLaunchKey, String hashKey);

    /**
     * 累加推广计划消耗
     * @param advertPlanId
     * @param fee
     * @return
     */
    Long incrTuiaAdvertPlanConsumeFee(Long advertPlanId, Long fee);
}
