package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.FutureTask;

import cn.com.duiba.nezha.engine.api.dto.ConsumerDto;
import cn.com.duiba.nezha.engine.api.dto.FusingOrientationPackageDto;
import cn.com.duiba.nezha.engine.api.dto.RcmdAdvertDto;
import cn.com.duiba.nezha.engine.api.dto.RecommendAppDto;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilter;
import cn.com.duiba.tuia.domain.model.AppDetail;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.duiba.tuia.domain.vo.AdxAdvertPriceVO;
import cn.com.tuia.advert.model.ObtainAdvertReq;
import cn.com.tuia.advert.model.ObtainAdvertRsp;

/**
 * Created by hujinliang on 2017/8/14.
 */
public interface AdvertRecommendService {

    void doObtainRecommendAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult,
                                 Map<Long, AdvertFilterVO> hasValidAdverts, AdvQueryParam advQueryParam,ConsumerDto consumerDto,
                                 AppDetail appDetail, AdvertFilter advertFilter);

    /**
     * adx 推荐广告
     *
     * @param req
     * @param rsp
     * @param filterResult
     * @param hasValidAdverts
     * @param advQueryParam
     * @param consumerDto
     */
    List<RcmdAdvertDto> adxRecommendAdvert(ObtainAdvertReq req, ObtainAdvertRsp rsp, FilterResult filterResult, Map<Long, AdvertFilterVO> hasValidAdverts, AdvQueryParam advQueryParam,ConsumerDto consumerDto, AdvertFilter advertFilter);

    void addRcmdAppOrCloseFusingPackage(Set<RecommendAppDto> recommendApps, Set<FusingOrientationPackageDto> fusingOrientationPackages);

    void dmpAdvertDOS(FilterResult filterResult, Long advertId, AdvertPriceVO advertPriceVO);
}
