package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.cache.ServiceManager;
import cn.com.tuia.advert.constants.SystemConfigKeyConstant;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 系统配置迁移
 *
 * @author lijicong
 * @since 2020-12-14
 */
@Service
@Slf4j
public class AdvertSystemConfigService {

    private static ServiceManager serviceManager;

    @Autowired
    public void setServiceManager(ServiceManager serviceManager) {
        AdvertSystemConfigService.serviceManager = serviceManager;
    }

    public static String get(AdvertSystemConfigEnum key) {
        String value = null;
        try {
            value = serviceManager.getStrValue(key.getSystemConfigKey());
        } catch (Exception e) {
            log.warn("系统配置 获取系统配置失败 configKey={}, error", key, e);
        }
        return StringUtils.isBlank(value) ? key.getDefaultValue() : value;
    }

    @Getter
    @AllArgsConstructor
    public enum AdvertSystemConfigEnum {
        //是否开启全部媒体为特权：1 开启 0 关闭
        appPrivilegeAllSwitch(SystemConfigKeyConstant.APP_PRIVILEGE_ALL, "0", int.class),
        //oCPC点击最低出价
        oCPCClickMinPrice(SystemConfigKeyConstant.OCPC_CLICK_MIN_PRICE, "10", long.class),
        //媒体开始素材推荐
        materialFilterConsumerCount(SystemConfigKeyConstant.MATERIAL_FILTER_CONSUMER_COUNT, "3", int.class),
        //重复曝光上限次数
        multipleExposureLimitCount(SystemConfigKeyConstant.MULTIPLE_EXPOSURE_LIMIT_COUNT, "3", int.class),
        //特殊代理商的OCPC底价配置
        specialAgentOCPCMinPrice(SystemConfigKeyConstant.SPECIAL_AGENT_OCPC_CONVERT_MIN_PRICE, "0", long.class),
        //兑吧CPC折扣率
        duibaCpcBidRate(SystemConfigKeyConstant.DUIBA_CPC_BID_RATE, "0.94", double.class),
        //谢谢参与数，单位：万，默认10万
        thksPartakeCount(SystemConfigKeyConstant.TUIA_THKS_PARTAKE_COUNT, "10", long.class),
        //流量分配速率，默认50%
        flowDistributionRate(SystemConfigKeyConstant.TUIA_FLOW_DISTRIBUTION_RATE, "0.5", double.class),
        //单用户广告主发券上限设置，默认1
        advertiserLaunchLimit(SystemConfigKeyConstant.TUIA_ADVERTISER_LAUNCH_LIMIT, "1", int.class),
        //单用户广告主发券发券间隔，默认5
        advertiserLaunchInterval(SystemConfigKeyConstant.TUIA_ADVERTISER_LAUNCH_INTERVAL, "5", int.class),
        ;

        private final String systemConfigKey;
        private final String defaultValue;
        private final Class<?> type;

        public String getValue() {
            return get(this);
        }

        public int getIntValue() {
            return Integer.parseInt(getValue());
        }

        public long getLongValue() {
            return Long.parseLong(getValue());
        }

        public double getDoubleValue() {
            return Double.parseDouble(getValue());
        }
    }

}


