/**
 * Project Name:engine-service
 * File Name:AdvertTargetAppService.java
 * Package Name:cn.com.duiba.tuia.service
 * Date:2018年7月10日下午2:24:51
 * Copyright (c) 2018, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.tuia.domain.dataobject.AdvertTargetAppDO;

/**
 * ClassName:AdvertTargetAppService <br/>
 * Function: 定向配置的定向媒体-广告位
 * Date:     2018年7月10日 下午2:24:51 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface AdvertTargetAppService {

    /**
     * 根据广告ID和定向包ID查询
     * @param advertId
     * @param orientPkgId
     * @return
     * @since JDK 1.6
     */
    AdvertTargetAppDO selectAppByAdvertId(Long advertId, Long orientPkgId) ;

    /**
     * 
     * selectAllTargetApps:(获取配置包定向媒体). <br/>
     *
     * @author chencheng
     * @param advertId
     * @param orientationId
     * @param rawOrientationId
     * @return
     * @since JDK 1.8
     */
    Set<Long> selectAllTargetApps(Long advertId, Long orientationId, Long rawOrientationId, Map<Long, Long> appTargetPackage);
}

