/**
 * Copyright (c) 2020, duiba.com.cn All Rights Reserved.
 */
package cn.com.duiba.tuia.service;

import lombok.Getter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Component;

/**
 * 描述: 阿波罗配置文件
 *
 * @author lijian
 * @version v1.0
 * @date 2020/8/15 13:47
 */
@Getter
@Component
@RefreshScope
public class ApolloConfig {

    private static final Logger logger = LoggerFactory.getLogger(ApolloConfig.class);

    //--------------风控反作弊配置---------------//
    /**
     * 命中风控作弊 切量测试占比
     */
    @Value("${riskCheat.test.Percent:0}")
    private Integer riskTestPercent;

    //--------------大禹平台---------------//
//    // 大盘发券场景
//    @Value("${tuia.nezha.dayu.scene.normal}")
//    private String sceneNoraml;
//
//    @Value("${tuia.nezha.dayu.scene.slotId}")
//    private String sceneSlotId;
//
//    // 双出价场景
//    @Value("${tuia.nezha.dayu.scene.DoubleFee}")
//    private String sceneDoubleFee;
//
//    @Value("${tuia.dayu.scene.pay}")
//    private String scenePay;
//
//    // 媒体需要的券类型的场景
//    @Value("${tuia.nezha.dayu.scene.AppRad}")
//    private String sceneAppRad;
//
//    @Value("${tuia.dayu.scene.aqyTag}")
//    private String sceneAqyTag;

    //--------------实验平台AB---------------//

//    @Value("${abtest.layer.code.normal:normal001,normal002,normal003}")
//    private String layerCodeNormal;
//
//    @Value("${abtest.layer.code.slotId:slotId001}")
//    private String layerCodeSlotId;
//
//    @Value("${abtest.layer.code.doubleFee:dfee001,dfee002}")
//    private String layerCodeDoubleFee;
//
//    @Value("${abtest.layer.code.pay:pay001,pay002,pay003,pay004}")
//    private String layerCodePay;
//
//    /** 媒体所要多张券类型 */
//    @Value("${abtest.layer.code.appRad:appRad001}")
//    private String layerCodeAppRad;
//
//    /** 爱奇艺tag */
//    @Value("${abtest.layer.code.aqyTag:aqyTag001}")
//    private String layerCodeAqyTag;
//
//    /** 落地页测试PV/UV分流实验层 */
//    @Value("${abtest.layer.code.promoteTest:PURLTESTPV,PURLTESTUV}")
//    private String layerCodePromoteTest;
//
//    /** 素材测试分流实验层 */
//    @Value("${abtest.layer.code.materialTest:MATRLTEST}")
//    private String layerCodeMaterialTest;
//
//    /** 域测试分流实验层 */
//    @Value("${abtest.layer.code.domainTest:MATRLTEST,PURLTESTUV}")
//    private String layerCodeDomainTest;

    /** 新素材扶持的分流比例 */
    @Value("${material.newsupport.ratio:10}")
    private Integer newMaterialSupportRatio;

//    @Value("${abtest.layer.code.adsupport:ADSUPPORT}")
//    private String layerCodeAdSupport;
//
//    /** 算法实验层；根据oneId进行uv分流 */
//    @Value("${abtest.layer.code.OneId:oneId001}")
//    private String layerCodeOneId;
}
