package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.elasticsearch.document.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;

/**
 * Created by hujinliang on 2017/5/26.
 */
public class CommandQueryConsumerInfo extends HystrixCommand<Consumer> {

    private final String deviceId;
    private final CosumerFeatureRepository cosumerFeatureRepository;
    private static final Logger logger = LoggerFactory.getLogger(CommandQueryConsumerInfo.class);
    @Autowired
    public CommandQueryConsumerInfo(String deviceId, CosumerFeatureRepository cosumerFeatureRepository) {
        super(Setter.withGroupKey(HystrixCommandGroupKey.Factory.asKey("Engine"))
                .andCommandKey(HystrixCommandKey.Factory.asKey("CommandQueryFeature"))
                .andThreadPoolKey(HystrixThreadPoolKey.Factory.asKey("QueryFeatureTheadPool"))
                .andCommandPropertiesDefaults(HystrixCommandProperties.Setter()
                        .withExecutionTimeoutInMilliseconds(100)));
        this.deviceId =deviceId;
        this.cosumerFeatureRepository = cosumerFeatureRepository;
    }

    @Override
    protected Consumer run() throws Exception {
        return cosumerFeatureRepository.findOne(deviceId);
    }
    @Override
    protected Consumer getFallback(){
        logger.error("CommandQueryFeatureInfo Error");
        return null;
    }
}