package cn.com.duiba.tuia.service;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.geo.api.dto.IpAreaDto;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.model.PhoneInfo;
import cn.com.duiba.tuia.domain.vo.AdvertVO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.Map;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年08月02日 11:53
 * @descript: 可能会公共的服务组件
 * @version: 1.0
 */
public interface CommonService {

    /**
     * 判断账户余额是否充足
     *
     * @param advertVO
     * @param fee
     * @return
     * @throws TuiaException
     */
    boolean isEnoughBudget(AdvertVO advertVO, Long fee) throws TuiaException;

    /**
     * 获取设备型号和价格区间
     * @param ua
     * @param userAgent
     * @return
     */
    PhoneInfo getPhoneInfo(String ua, String userAgent);

    /**
     * 
     * ipGeoAnalysis:(根据ip解析城市、运营商信息). <br/>
     *
     * @author chencheng
     * @param ip
     * @param isLog
     * @param filterResult 
     * @return
     * @since JDK 1.8
     */
     AdvQueryParam ipGeoAnalysis(String ip);

    /**
     * ipGeoAnalysis:(根据ip解析城市、运营商信息).参数包含活动传过来的地域解析信息
     * @param ip ip地址
     * @param ipAreaDto 活动传过来的地域解析信息
     * @param reqMap    相关的经纬度信息
     * @param reqMap    相关的经纬度信息
     * @return deviceId
     */
    AdvQueryParam ipGeoAnalysis(String ip, IpAreaDto ipAreaDto, Map<String, String> reqMap, String deviceId, boolean activityPriorityCondition, DeviceTagDto deviceTagDto, FilterResult filterResult);

    /**
     * 根据ip或者城市编码，组装
     * @param ip
     * @param cityId
     * @param typeGeo 1-IP，2-城市编码
     * @param reqMap    相关的经纬度信息
     * @return
     */
     AdvQueryParam ipOrCityIdGeoAnalysis(String ip, String cityId, Integer typeGeo, Map<String, String> reqMap, boolean meetGeoHashCondition, DeviceTagDto deviceTagDto, FilterResult filterResult);

    /**
     * 当前用户地理位置信息数据是否满足活动高优先级条件
     *
     * @param logExtMap {@link ObtainAdvertReq#getLogExtMap()}
     * @param ipAreaDto {@link ObtainAdvertReq#getIpAreaDto()}
     * @return
     */
    boolean isMeetActivityPriorityCondition(Map<String, String> logExtMap, IpAreaDto ipAreaDto);

    /**
     * 当前地理位置信息是否不为空 且不在黑名单中
     *
     * @param logExtMap
     * @param ipAreaDto
     * @return
     */
    boolean isMeetGeoHashCondition(Map<String, String> logExtMap, IpAreaDto ipAreaDto);
}
