/**
 * Project Name:engine-service
 * File Name:ConsumerRecordSerivce.java
 * Package Name:cn.com.duiba.tuia.service
 * Date:2017年5月12日下午1:59:41
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;
import java.util.Set;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.tuia.advert.model.ObtainAdvertReq;

/**
 * ClassName:ConsumerRecordSerivce <br/>
 * Function: TODO ADD FUNCTION. <br/>
 * Reason:	 TODO ADD REASON. <br/>
 * Date:     2017年5月12日 下午1:59:41 <br/>
 * @author   zp
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
public interface ConsumerRecordSerivce {

    /**
     * 查询当天某个活动的参与次数
     * getTodayAcJoinTimes:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param consumerVOs
     * @param activityId
     * @return
     * @since JDK 1.6
     */
    Integer getTodayAcJoinTimes(List<ConsumerInteractiveRecordDO> consumerVOs,Long activityId);

    /**
     * 查询用户周期内领券广告id
     * getHistoryJoinAdverts:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param consumerVOs
     * @param days
     * @return
     * @since JDK 1.6
     */
    List<Long> getHistoryJoinAdverts(List<ConsumerInteractiveRecordDO> consumerVOs,Integer days);

    /**
     * 查询用户周期内领券次数
     * getHistoryAdvertTims:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param consumerVOs
     * @param days
     * @return
     * @since JDK 1.6
     */
    Map<Long,Integer> getHistoryAdvertTims(List<ConsumerInteractiveRecordDO> consumerVOs,Integer days);

    Map<Long,Integer> getHistoryAdvertTimsMysql(ObtainAdvertReq req, Integer days);

    Map<Long, Integer> getHistoryAdvertTimes(ObtainAdvertReq req, Integer days, Map<String, Integer> allUserAdxMap);


    /**
     * 查询周期内用户是否有领取记录
     * isNewConsumer:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param consumerVOList
     * @return
     * @since JDK 1.6
     */
    Boolean isNewConsumer(List<ConsumerInteractiveRecordDO> consumerVOList);
    
    /**
     * 获取用户最近times次中券特殊标签
     * getTags:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param record
     * @param times
     * @return
     * @since JDK 1.6
     */
    Set<String> getTags(List<ConsumerInteractiveRecordDO> consumerVOList,Integer times);
    
    /**
     * 异步执行
     * addRecordReq:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param order
     * @param limitAccountType 类型
     * @param accountId 广告主id
     * @param vo
     * @param slotDirection 广告位定向导量出券 1-是 2-否
     * @param filterResult 
     * @since JDK 1.6
     */
    void addRecordReq(AdvertOrderDO order,String tags,Long materialId, Long accountId, String limitAccountType,
                      String slotDirection, FilterResult filterResult, Boolean testPlanMaterial, OrderJsonVO vo);
}

