package cn.com.duiba.tuia.service;

import java.util.List;
import java.util.Map;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.AqyAttributeDto;
import cn.com.duiba.tuia.domain.dataobject.ConsumerInteractiveRecordDO;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.exception.TuiaException;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2017年05月02日 19:16
 * @descript:
 * @version: 1.0
 */
public interface ConsumerService {
    /**
     * 标记领取的广告已点击
     *
     * @param consumerId
     * @param advertId
     * @return
     */
    void flagAdvertClicked(Long consumerId, Long advertId);

    /**
     * 获取所有广告的信息：点击状态 + 领取次数
     *
     * @param consumerId
     * @return
     */
    Map<Long, Integer> getAllClickStatus(Long consumerId);

    /**
     * 获取用户key:K39_${consumerId}_${date}
     *
     * @param consumerId
     * @return
     */
    String formatConsumerKey(Long consumerId);

    /**
     * 获取用户当天领取次数：先时间降序排序（减少遍历次数）在获取当前时间的广告
     * @param consumerVOS
     * @return
     */
    Map<Long,Integer> getConsumerLimit(List<ConsumerInteractiveRecordDO> consumerVOS);

    
    /**
     * 
     * getTodayConsumerList:(获取今日的用户领券数据). <br/>
     *
     * @author chencheng
     * @param consumerVOS
     * @return
     * @since JDK 1.8
     */
    List<ConsumerInteractiveRecordDO> getTodayConsumerList(List<ConsumerInteractiveRecordDO> consumerVOS);

    /**
     * 
     * getLimitAccountIds:(获取用户对应的受发券限制的广告主). <br/>
     * @author chencheng
     * @param todayConsumeList 今日领券记录
     * @return
     * @throws TuiaException 
     * @since JDK 1.8
     */
    List<Long> getLimitAccountIds(List<ConsumerInteractiveRecordDO> todayConsumeList) throws TuiaException;

    /**
     * 
     * getPercentTest:(广告主发券限制测试用户比例，测试代码，后期会删除). <br/>
     *
     * @author chencheng
     * @return
     * @since JDK 1.8
     */
    int getPercentTest();
    
    /**
     * 
     * setFilterResultConsumeList:(FilterResult的用户领券记录). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @throws TuiaException 
     * @since JDK 1.8
     */
    void setFilterResultConsumeList(FilterResult filterResult, List<ConsumerInteractiveRecordDO> consumerVOList) throws TuiaException;

    /**
     * 获取爱奇艺标签数据
     *
     * @param deviceId
     */
    AqyAttributeDto getAqyAttribute(String deviceId);

    /**
     * 获取用户性别数据
     *
     * @param deviceId
     */
    String getAqySexFeature(String deviceId);
}
