package cn.com.duiba.tuia.service;


import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Repository;

import cn.com.duiba.tuia.elasticsearch.document.Consumer;

/**
 * Created by hujinliang on 2017/6/5.
 */
@Repository
public class CosumerFeatureRepository {
    
    private static String CONSUMER_COLLECTION = "consumer_device_feature";
    private static final Logger logger              = LoggerFactory.getLogger(CosumerFeatureRepository.class);

    @Autowired
    private MongoTemplate mongoTemplate;

    public Consumer findOne(String deviceId){
        try {
            if(Strings.isNullOrEmpty(deviceId))return null;
            return mongoTemplate.findOne(Query.query(Criteria.where("_id").is(deviceId)), Consumer.class,
                                         CONSUMER_COLLECTION);
        } catch (Exception ex) {
            logger.error(ex.getMessage(), ex);
        }
        return null;
    } 
}