package cn.com.duiba.tuia.service;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.form.DMPForm;
import cn.com.duiba.bigdata.dmp.service.api.remoteservice.remoteservice.RemoteDMPService;
import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.tuia.enums.CatGroupEnum;
import cn.com.duiba.tuia.tool.CatUtil;
import com.alibaba.fastjson.JSON;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixCommand;
import com.netflix.hystrix.contrib.javanica.annotation.HystrixProperty;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.*;

@Slf4j
@Service
public class DmpTagDataService {

    @Reference
    private RemoteDMPService remoteDMPService;

    @Resource(name="dmpExecutorService")
    private ExecutorService dmpExecutorService;


    public DeviceTagDto getDeviceTag(String deviceId, final boolean activityPriorityCondition) {
        if (StringUtils.isBlank(deviceId)) {
            CatUtil.catLog(CatGroupEnum.CAT_102020.getCode());
            return new DeviceTagDto();
        }
        try {
            DMPForm dmpForm = new DMPForm();
            dmpForm.setDeviceId(deviceId);

            Future<DeviceTagDto> pkgSubmit = dmpExecutorService.submit(() -> activityPriorityCondition ? getDevicePkg(dmpForm) : getDeviceNewPkg(dmpForm));
            Future<DeviceTagDto> tagSubmit = dmpExecutorService.submit(() -> getDeviceActionData(dmpForm));

            //获取人群包数据
            DeviceTagDto devicePkg = pkgSubmit.get(20, TimeUnit.MILLISECONDS);
            //获取标签数据
            DeviceTagDto deviceActionData = tagSubmit.get(20, TimeUnit.MILLISECONDS);

            //将人群包数据，放到标签数据，融合
            DeviceTagDto deviceTagDto = FuseAtoB(devicePkg, deviceActionData);

            return deviceTagDto == null ? new DeviceTagDto() : deviceTagDto;
        } catch (TimeoutException e) {
            CatUtil.log(CatGroupEnum.CAT_107032.getCode());
            return new DeviceTagDto();
        } catch (Exception e) {
            CatUtil.catLog(CatGroupEnum.CAT_107024.getCode());
            log.warn("getDeviceTag is error", e);
            return new DeviceTagDto();
        }
    }


    public List<String> getDeviceBaseTag(String deviceId) {
        if (StringUtils.isBlank(deviceId)) {
            return Collections.emptyList();
        }

        List<String> rtnList = new ArrayList<>();
        try {
            DMPForm dmpForm = new DMPForm();
            dmpForm.setDeviceId(deviceId);
            String deviceBaseData = getDeviceBaseData(dmpForm);
            if(StringUtils.isNotBlank(deviceBaseData)) {
                Map<String, String> map = JSON.parseObject(deviceBaseData, Map.class);
                for (String value : map.values()) {
                    if (StringUtils.isNotBlank(value)) {
                        String[] split = value.split(",");
                        rtnList.addAll(Arrays.asList(split));
                    }
                }
            }
        }catch (Exception e){
            return Collections.emptyList();
        }

        return rtnList;
    }



    @DBTimeProfiler
    @HystrixCommand(
            fallbackMethod = "getDeviceBaseFallback",
            commandProperties = {@HystrixProperty(name = "execution.isolation.thread.timeoutInMilliseconds", value = "10")})
    private String getDeviceBaseData(DMPForm dmpForm) {

        try {
            return remoteDMPService.getImeiTag(dmpForm);
        } catch (Exception e) {
            CatUtil.catLog(CatGroupEnum.CAT_107025.getCode());
            return null;
        }
    }

    /**
     * 获取设备号对应的人群包
     *
     * @param dmpForm dmp查询对象
     * @return 人群包
     */
    public String getDeviceBaseFallback(DMPForm dmpForm) {
        CatUtil.catLog(CatGroupEnum.CAT_107029.getCode());
        return null;
    }


    @DBTimeProfiler
    @HystrixCommand(
            fallbackMethod = "getDevicePkgFallback",
            commandProperties = {@HystrixProperty(name = "execution.isolation.thread.timeoutInMilliseconds", value = "10")})
    private DeviceTagDto getDevicePkg(DMPForm dmpForm) {

        try {
            return remoteDMPService.getDevicePkg(dmpForm);
        } catch (Exception e) {
            CatUtil.catLog(CatGroupEnum.CAT_107026.getCode());
            return new DeviceTagDto();
        }
    }

    @DBTimeProfiler
    @HystrixCommand(
            fallbackMethod = "getDevicePkgFallback",
            commandProperties = {@HystrixProperty(name = "execution.isolation.thread.timeoutInMilliseconds", value = "10")})
    private DeviceTagDto getDeviceNewPkg(DMPForm dmpForm) {

        try {
            return remoteDMPService.getDeviceNewPkg(dmpForm);
        } catch (Exception e) {
            CatUtil.catLog(CatGroupEnum.CAT_107027.getCode());
            return new DeviceTagDto();
        }
    }


    @DBTimeProfiler
    @HystrixCommand(
            fallbackMethod = "getDeviceTagFallback",
            commandProperties = {@HystrixProperty(name = "execution.isolation.thread.timeoutInMilliseconds", value = "10")})
    private DeviceTagDto getDeviceActionData(DMPForm dmpForm) {
        try {

            return remoteDMPService.getDeviceActionData(dmpForm);
        } catch (Exception e) {
            CatUtil.catLog(CatGroupEnum.CAT_107028.getCode());
            return new DeviceTagDto();
        }
    }

    private DeviceTagDto FuseAtoB(DeviceTagDto devicePkg, DeviceTagDto deviceTag) {

        if (devicePkg == null) {
            devicePkg = new DeviceTagDto();
        }

        if (deviceTag == null) {
            deviceTag = new DeviceTagDto();
        }

        deviceTag.setExternalPackage(devicePkg.getExternalPackage());
        deviceTag.setAlgDirectionalPackage(devicePkg.getAlgDirectionalPackage());
        deviceTag.setAlgTestPackage(devicePkg.getAlgTestPackage());
        deviceTag.setAlgExcludePackage(devicePkg.getAlgExcludePackage());
        deviceTag.setBusinessTagPackage(devicePkg.getBusinessTagPackage());
        deviceTag.setOfflineTagPackage(devicePkg.getOfflineTagPackage());
        //需求新增  设置dmp返回的地理位置信息
        deviceTag.setRegionInfoTags(devicePkg.getRegionInfoTags());

        return deviceTag;
    }

    /**
     * 获取设备号对应的人群包
     *
     * @param dmpForm dmp查询对象
     * @return 人群包
     */
    public DeviceTagDto getDevicePkgFallback(DMPForm dmpForm) {
        CatUtil.catLog(CatGroupEnum.CAT_107030.getCode());
        return new DeviceTagDto();
    }

    /**
     * 获取设备号对应的标签
     *
     * @param dmpForm dmp查询对象
     * @return 标签
     */
    public DeviceTagDto getDeviceTagFallback(DMPForm dmpForm) {
        CatUtil.catLog(CatGroupEnum.CAT_107031.getCode());
        return new DeviceTagDto();
    }



}
