package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.List;

/**
 * 域测试服务接口
 *
 * @author zhangbaiqiang
 * @date 2021/3/29
 */
public interface DomainTestService {

    /**
     * 查询域测试的实验组的落地页（缓存）
     *
     * @param planId 测试计划Id
     * @return 落地页列表
     */
    List<String> selectGroupPromoteUrlCache(Long planId);

    /**
     * 校验域测试所有实验组的落地页链接是否有效
     *
     * @param planId 测试计划Id
     * @param advertId 广告Id
     * @param req 广告请求参数
     * @param filterResult 过滤结果
     * @return 是否全部有效
     */
    boolean isPlanValid(Long planId, Long advertId, ObtainAdvertReq req, FilterResult filterResult);
}
