package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.dataobject.AdvertOrderDO;
import cn.com.duiba.tuia.domain.dataobject.AdxAdvertMaterialDO;
import cn.com.duiba.tuia.domain.vo.OrderJsonVO;
import cn.com.tuia.advert.model.SpmlogReq;

/**
 * @date: 2020年04月09日 19:16
 * @descript:DSP adx广告竞价处理接口
 * @version: 1.0
 */
public interface DspComparePriceService {

    /**
     * 初始化dsp有效adx广告数据到本地缓存
     *
     * @param
     */
    void init();

    /**
     * 更新adx广告缓存
     * updateAdxAdvertCache:(这里用一句话描述这个方法的作用). <br/>
     *
     * @param key:dspId+";"+advertId
     * @author lijian
     * @since JDK 1.8
     */
    void updateAdxAdvertCache(String key);

    /**
     * 根据dspId,advertId 获取 adx广告缓存数据
     *
     * @param dspId
     * @param advertId
     * @return
     */
    AdxAdvertMaterialDO getAdxAdvertCache(Long dspId, Long advertId);


    /**
     * 根据dspId,advertId 获取 有效的adx广告
     *
     * @param dspId
     * @param advertId
     * @return
     */
    AdxAdvertMaterialDO getValidAdxAdvert(Long dspId, Long advertId);

    /**
     * 根据dspID 和adxAdvertId查询有效adx广告
     *
     * @return
     */
    AdxAdvertMaterialDO getAdxAdvertByAdxAdvertId(Long dspId, Long advertId);


    /**
     * dsp adx 广告曝光日志
     *
     * @param req
     */
    void adxAdvertShowLog(SpmlogReq req, AdvertOrderDO advertOrderDO, OrderJsonVO vo);


    /**
     * dsp adx 广告计费日志
     *
     * @param req
     */
    void adxAdvertConsumeLog(SpmlogReq req, AdvertOrderDO advertOrderDO, OrderJsonVO vo);

    /**
     * dsp adx 广告点击日志
     *
     * @param req
     */
    void adxAdvertClickLog(SpmlogReq req, AdvertOrderDO advertOrderDO, OrderJsonVO vo);



}
