package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.LayeredStrategyAdvertDto;
import cn.com.duiba.tuia.domain.model.LayeredStrategyWeightDto;
import cn.com.duiba.tuia.domain.vo.AdvertPriceVO;
import cn.com.tuia.advert.model.ObtainAdvertReq;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * [广告分媒体调控]服务接口
 *
 * @author zhangbaiqiang
 * @date 2020/7/23
 */
public interface LayeredStrategyService {

    /**
     * 计算媒体权重
     *
     * @param advertPriceVO 广告信息
     * @param weight 原先的权重
     * @param strategyMap 策略映射
     * @return 计算媒体权重后的权重
     */
    Double calculateAppWeight(AdvertPriceVO advertPriceVO, Double weight, Map<Long, List<LayeredStrategyWeightDto>> strategyMap);

    /**
     * 查询广告配置-策略权重映射(本地缓存)
     *
     * @param appId 媒体id
     * @return 广告配置-策略权重映射
     */
    Map<Long, List<LayeredStrategyWeightDto>> queryStrategyWeightMapCache(Long appId);

    /**
     * 查询策略广告列表(Redis缓存)
     *
     * @return 策略列表
     */
    List<LayeredStrategyAdvertDto> queryStrategyAdvertList();

    /**
     * 查询策略配置的流量包的媒体ID
     *
     * @param strategyId 策略id
     * @return 媒体ID集合
     */
    Set<Long> queryAppIdsByStrategyId(Long strategyId);

    /**
     * [广告指定媒体提权]获取指定媒体的广告-提权映射，并进行分流，如果分流未命中返回空map
     *
     * @param appId 媒体Id
     * @param req 广告请求参数
     * @return 广告-权重映射
     */
    Map<Long, Double> querySpecifyWeightMap(Long appId, ObtainAdvertReq req);

    /**
     * [广告指定媒体提权]计算权重
     *
     * @param advertPriceVO 广告信息
     * @param weight 原先的权重
     * @param specifyWeightMap 广告-权重映射
     * @return 计算权重后的权重
     */
    Double calculateSpecifyWeight(AdvertPriceVO advertPriceVO, Double weight, Map<Long, Double> specifyWeightMap);
}
