package cn.com.duiba.tuia.service;

import java.util.List;

import cn.com.duiba.tuia.domain.dataobject.AdvertLimitingDO;
import cn.com.duiba.tuia.exception.TuiaException;

/**
 * @author: panaihua
 * @date: 2017年03月03日 11:23
 * @descript: 限流已经达到峰值的应用缓存
 * <p>不需要初始化，如果获取是空的，说明今天还没有达到峰值的APP</p>
 * @version: 1.0
 */
public interface LimitingMaximunService {

    /**
     * 判断广告媒体是否已达到限流峰值
     * çç
     * @param advertId
     * @param orientationPackageId 配置id
     * @param appId
     * @param initialOrientationId 原始配置id
     * @return
     */
    boolean hasInLimitingMaximunApps(final Long advertId, Long orientationPackageId, Long appId,Long slotId, Long initialOrientationId);
    
    /**
     * 校验并更新限流媒体广告&媒体
     * updateLimitingMaximunCache:(这里用一句话描述这个方法的作用). <br/>
     * @author zp
     * @param advertId
     * @param appId
     * @since JDK 1.6
     */
    void updateLimitingMaximunCache(Long advertId, Long orientationPackageId, Long appId);

    /**
     * 更新限流媒体广告&媒体
     * @param advertLimitingDO
     * @return
     */
    boolean checkLimitingMaximunApps( AdvertLimitingDO advertLimitingDO);
    /**
     * 初始化限流媒体
     *
     * @param advertIds
     */
    void initLimiting(List<Long> advertIds) throws TuiaException;

    /**
     *
     * @param advertId
     * @param planId
     * @param appId 媒体id
     * @return
     */
    List<AdvertLimitingDO> getAdvertLimitCache(Long advertId,Long planId,Long appId);

}
