package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.dataobject.OrderCustomAdvertDO;
import cn.com.tuia.advert.model.ObtainAdvertReq;

/**
 * 券次序定制广告接口
 *
 * @author zhangbaiqiang
 * @date 2021/6/11
 */
public interface OrderCustomAdvertService {

    /**
     * 判断开关是否开启（广告位开关开启&&命中实验）
     *
     * @param req 广告请求参数
     * @return true.开启 false.关闭
     */
    boolean isSwitchOpen(ObtainAdvertReq req);


    /**
     * 查询配置
     * @param slotId
     * @param orderCount
     * @return
     */
    OrderCustomAdvertDO getConfigBySlotIdAndOrderCount(Long slotId, Integer orderCount);


    /**
     * 刷新缓存
     *
     * @param slotId 广告位Id
     */
    void refreshCache(Long slotId);

}
