package cn.com.duiba.tuia.service;

import cn.com.duiba.bigdata.dmp.service.api.remoteservice.dto.DeviceTagDto;
import cn.com.duiba.tuia.domain.vo.RTAAdvertPlanVO;
import cn.com.tuia.advert.model.RTAAdvertPlanDto;
import cn.com.tuia.advert.model.RTAObtainReq;
import cn.com.tuia.advert.model.RTAObtainRsp;
import cn.com.tuia.advert.service.RTAEngineService;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @program: tuia-engine
 * @description:
 * @author: Micheal.Wang
 * @blog: <a href="http://www.micheal.top">MichealWang</a>
 * @create: 2020-04-17 15:23
 **/
@RestController
public class RTAEngineServiceImpl implements RTAEngineService {

    @Autowired
    private RTAService rtaService;

    @Override
    public List<RTAAdvertPlanDto> getRTAAdvertPlan() {
        return rtaService.query();
    }

    @Override
    public RTAObtainRsp obtainRtaAdvert(RTAObtainReq rtaObtainReq) {
        RTAObtainRsp rtaObtainRsp = new RTAObtainRsp();
        // 默认全部放弃
        List<Long> extAccountIds = rtaObtainReq.getExtAccountIds();
        rtaObtainRsp.setGiveUp(extAccountIds);
        rtaObtainRsp.setNotGiveUp(Collections.emptyList());
        rtaObtainReq.setExtMap(Maps.newHashMap());
        // 爱奇艺场景设置为0 默认值
        rtaObtainRsp.setExtGroopId(0L);

        DeviceTagDto rtaDMPTags = rtaService.getRtaDMPTags(rtaObtainReq);
        if(rtaDMPTags==null){
            return rtaObtainRsp;
        }

        // 获取我们平台配置的RTA投放计划
        Map<Long,RTAAdvertPlanVO> accountIdMappingAdvertPlanVO= rtaService.getByChannelId(rtaObtainReq.getAppId());
        if(MapUtils.isEmpty(accountIdMappingAdvertPlanVO)){
            return rtaObtainRsp;
        }

        List<String> externalPackage = rtaDMPTags.getExternalPackage();
        if(CollectionUtils.isEmpty(externalPackage)){
            return rtaObtainRsp;
        }

        if(CollectionUtils.isEmpty(extAccountIds)){
            return rtaObtainRsp;
        }
        // 以上都是返回默认，并且不过滤
        // 过滤
        List<Long> noGiveUp = extAccountIds.stream().filter(extAccountId -> {
            RTAAdvertPlanVO rtaAdvertPlanVO = accountIdMappingAdvertPlanVO.get(extAccountId);
            //没有在我们平台配置账号
            if(rtaAdvertPlanVO==null){
                return false;
            }
            List<String> sheildInterestTags = rtaAdvertPlanVO.getSheildInterestTags();
            if(CollectionUtils.isEmpty(sheildInterestTags)){
                return true;
            }
            // 所有标签都不能命中屏蔽标签
            return sheildInterestTags.stream().allMatch(tag->!externalPackage.contains(tag));
        }).filter(extAccountId -> {
            RTAAdvertPlanVO rtaAdvertPlanVO = accountIdMappingAdvertPlanVO.get(extAccountId);
            //没有在我们平台配置账号
            if(rtaAdvertPlanVO==null){
                return false;
            }
            List<String> targetedInterestTags = rtaAdvertPlanVO.getTargetedInterestTags();
            if(CollectionUtils.isEmpty(targetedInterestTags)){
                return true;
            }
            // 只要有一个标签命中定向标签
            return targetedInterestTags.stream().anyMatch(tag->externalPackage.contains(tag));
        }).collect(Collectors.toList());

        rtaObtainRsp.setNotGiveUp(noGiveUp);
        //获取过滤掉的部分
        extAccountIds.removeAll(noGiveUp);
        rtaObtainRsp.setGiveUp(extAccountIds);

        // 处理返回放弃的广告账号id
        return rtaObtainRsp;
    }


}
