package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.RepeatTestGroup;

import java.util.List;

/**
 * [重复发券测试需求]接口
 *
 * @author zhangbaiqiang
 * @date 2020/7/15
 */
public interface RepeatAdvertTestService {

    /**
     * 计算用户分流的测试组
     *
     * @param consumerId 用户id
     * @return 测试组
     */
    RepeatTestGroup calculateRepeatTestGroup(Long consumerId);

    /**
     * 查询配置的测试组
     *
     * @return 测试组列表
     */
    List<RepeatTestGroup> queryRepeatTestGroups();

    /**
     * 判断测试组的间隔小于当天已经过去的时间
     *
     * @param group 测试组
     * @return 是否小于
     */
    Boolean isRepeatIntervalLessThanTodayHours(RepeatTestGroup group);
}
