package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.model.AdvOrientationItem;
import cn.com.duiba.tuia.domain.model.AdvQueryParam;
import cn.com.duiba.tuia.domain.model.AdvertFilterType;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.hutool.core.collection.ConcurrentHashSet;

import java.util.List;

public interface RepeatExposureFilterService {


    /**
     * 重复曝光内存过滤
     * @param listAdvOrientationItem
     * @param advQueryParam
     * @param filterTypeSets
     * @return
     */
    List<AdvOrientationItem> repeatExposureFilter(List<AdvOrientationItem> listAdvOrientationItem, AdvQueryParam advQueryParam, ConcurrentHashSet<AdvertFilterType> filterTypeSets);

    /**
     * 重复曝光过滤+释放
     * @param listAdvOrientationItem
     * @param advQueryParam
     * @param filterTypeSets
     * @param filterResult
     * @return
     */
    List<AdvOrientationItem> filterRepeatExposureAd(List<AdvOrientationItem> listAdvOrientationItem, AdvQueryParam advQueryParam, ConcurrentHashSet<AdvertFilterType> filterTypeSets, FilterResult filterResult);



}
