package cn.com.duiba.tuia.service;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;

import cn.com.duiba.tuia.domain.dataobject.ResoureTagsDO;
import cn.com.tuia.advert.enums.ResourceTagsTypeEnum;
import cn.com.duiba.tuia.exception.TuiaException;

/**
 * 
 * ClassName: ResourceTagsService <br/>
 * Function: 资源对应标签service. <br/>
 * date: 2017年7月31日 下午4:47:52 <br/>
 *
 * @author chencheng
 * @version
 */
public interface ResourceTagsService {

    /**
     * 获取资源对应标签列表
     * @param resourceId 资源id
     * @param type 类型 @{ResourceTagsTypeEnum}
     */
    Set<String> getResoureTagsDOById(Long resourceId, ResourceTagsTypeEnum typeEnum);

    void refreshResourceCache(Long resourceId);


    /**
     * 初始化资源对应标签列表
     * @throws TuiaException 
     */
    void init() throws TuiaException;

    /**
     * 根据资源id集合和类型获取资源对应标签Map
     *
     * @author chencheng
     * @param resourceIdSet
     * @param resourceTagsTypeEnum
     * @return
     * @throws ExecutionException 
     */
    Map<Long, Set<String>> getResourceTagsMapByIdSet(Set<Long> resourceIdSet, ResourceTagsTypeEnum resourceTagsTypeEnum) throws ExecutionException;

    /**
     * 根据素材id从缓存中获取素材实体DO
     *
     * @param materialId  素材id
     * @return
     */
    Optional<ResoureTagsDO> getMaterialTagsDO(Long materialId);
}
