/**
 * Project Name:engine-service
 * File Name:ResourcesRepeatLunchService.java
 * Package Name:cn.com.duiba.tuia.service.impl
 * Date:2019年1月11日上午10:22:26
 * Copyright (c) 2019, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.service;

import java.util.Map;

import cn.com.duiba.tuia.domain.dataobject.AdvertRepeatLunchConfigDO;
import cn.com.duiba.tuia.domain.model.FilterResult;
import cn.com.duiba.tuia.domain.vo.AdvertFilterVO;

/**
 * ClassName:ResourcesRepeatLunchService <br/>
 * Function: 资源维度重复发券逻辑. <br/>
 * Date:     2019年1月11日 上午10:22:26 <br/>
 * @author   chencheng
 * @version  
 * @since    JDK 1.8
 * @see 	 
 */
public interface ResourcesRepeatLunchService {
    
    /**
     * 
     * resourcesRepeatLunch:(资源重复发券过滤). <br/>
     *
     * @author chencheng
     * @param filterResult
     * @param validAdverts
     * @param platform
     * @return
     * @since JDK 1.8
     */
    Map<Long, AdvertFilterVO> resourcesRepeatLunch(FilterResult filterResult, Map<Long, AdvertFilterVO> validAdverts, String platform);
    
    /**
     * 
     * getAdvertRepeatLunchConfigOrDefult:(根据key获取默认发券间隔配置，或自定义间隔配置). <br/>
     *
     * @author chencheng
     * @param key
     * @param configMap
     * @return
     * @since JDK 1.8
     */
    AdvertRepeatLunchConfigDO getAdvertRepeatLunchConfigOrDefult(String key, Map<String, AdvertRepeatLunchConfigDO> configMap);
    
    /**
     * 
     * repeatLunchRelease:(判断过滤后是否进行重复过滤逻辑的释放). <br/>
     *
     * @author chencheng
     * @param filterValidAdverts
     * @return
     * @since JDK 1.8
     */
    boolean repeatLunchRelease(Map<Long, AdvertFilterVO> filterValidAdverts);
    
}

