package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.dataobject.AppDO;
import cn.com.duiba.tuia.domain.dataobject.SlotDO;
import cn.com.duiba.tuia.domain.model.AppDetail;
import cn.com.duiba.tuia.domain.model.AdvBannedTag;
import cn.com.duiba.tuia.domain.model.CheckStrategyRet;
import cn.com.duiba.tuia.exception.TuiaException;

import java.util.List;

/**
 * 屏蔽策略
 * Created by zhengjy on 2017/4/14.
 */
public interface ShieldingStrategyService {
    /**
     * 获取屏蔽标签列表
     * @param appDO
     * @return
     */
    List<String> getTags(AppDO appDO, SlotDO slotDO, Boolean isHandledSlot);

    /**
     * 处理屏蔽标签，行业-资源-属性-落地页
     * @param appDO
     * @param slotDO
     * @param isHandledSlot
     * @param advBannedTag
     */
    void handleBannedTag(AppDO appDO, SlotDO slotDO, boolean isHandledSlot, AdvBannedTag advBannedTag);

    /**
     * 获取屏蔽的素材标签
     * @return
     */
    List<String> getShieldMaterialTags(AppDO appDO, SlotDO slotDO);

    /**
     * 验证策略
     * @param appDO
     * @param slotDO
     * @param cityId 城市id
     * @param isProxy 当前用户是否代理/VPN流量  true:是，false：否
     * @return true：当前策略不满足条件，继续下一个验证，false：不需要下一个验证
     */
    CheckStrategyRet checkStrategy(AppDO appDO, SlotDO slotDO, Boolean isProxy, String cityId, Long slotId) throws TuiaException;

    /**
     * 是否新媒体策略屏蔽
     * @return
     */
    String getShieldingStrategyType();

    /**
     * 是否发送福袋
     * @param obj
     * @return
     */
    boolean isSendLuckybag(Object obj);

    /**
     * 查询该广告位的白名单列表
     * @param appDetail
     * @return
     * @throws TuiaException
     */
    List<Long> getSlotWhiteList(AppDetail appDetail) throws TuiaException;


    /**
     * 获取策略code用于计算白名单竞价排序开关
     */
    Integer getStrategyCode();

}
