package cn.com.duiba.tuia.service;

import cn.com.duiba.tuia.domain.dataobject.MediaAccountWhiteDO;
import cn.com.duiba.tuia.domain.dataobject.MediaAdvertWhiteDO;
import cn.com.duiba.tuia.exception.TuiaException;
import cn.com.duiba.tuia.ssp.center.api.dto.slot.SlotListStatusDto;

import java.util.List;

/**广告位白名单服务接口
 * Created by jzl on 18/4/16.
 */
public interface SlotWhiteListService {

    /**
     * 查询广告位白名单,默认策略的
     * @param slotId
     * @return
     * @throws TuiaException
     */
    List<Long> selectList(Long slotId) throws TuiaException;

    /**
     * 查询广告位白名单，新策略的
     * @param strategyType
     * @param strategyId
     * @param slotId
     * @return
     * @throws TuiaException
     */
    List<Long> selectList(String strategyType, Long strategyId, Long slotId) throws TuiaException;

    /**
     * 判断当前广告是否在广告位白名单(此白名单位媒体端的,非管理后台)中
     * @return
     */
//    Boolean isSlotAdvertInWhiteList(String slotAdvertStr) throws TuiaException;


    SlotListStatusDto isOpenSwitch(Long slotId);

    /**
     * 根据广告位id查询 媒体广告位名单（广告维度）
     * @param slotId
     * @return
     */
    List<MediaAdvertWhiteDO> queryMediaAdvertList(Long slotId);

    /**
     * 根据广告位id查询 媒体广告位名单（广告主维度）
     * @param slotId
     * @return
     */
    List<MediaAccountWhiteDO> queryMediaAccountList(Long slotId);

    /**
     * 通知刷新 媒体广告位黑白名单
     */
    void updateMediaList(Long slotId);

    /**
     * 通知刷新 媒体广告位黑白名单开关状态
     */
    void updateMediaOpenStatus(Long slotId);
}
