package cn.com.duiba.tuia.service;


import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

import cn.com.duiba.nezha.engine.api.enums.ResultCodeEnum;
import cn.com.duiba.nezha.engine.api.enums.StatTypeEnum;
import cn.com.duiba.nezha.engine.api.enums.TagTopNTypeEnum;
import cn.com.duiba.nezha.engine.api.support.RecommendEngineException;
import cn.com.duiba.tuia.domain.dataobject.AdvertRcmdTagPreferenceTopEntity;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by pc on 2016/10/18.
 */
@Service
public class TagCandidateService {

    private static final Logger logger = LoggerFactory.getLogger(TagCandidateService.class);

    private static final Long EXPIRE_TIME = 5 * 60L;

    private static final Long TOP_COUNT=70L;

    @Autowired
    AdvertRcmdTagPreferenceTopBo advertRcmdTagPreferenceTopBo;

    private final LoadingCache<Key, List<String>> cache       = CacheBuilder.newBuilder
            ().expireAfterWrite(EXPIRE_TIME, TimeUnit.SECONDS).build(
            new CacheLoader<Key, List<String>>() {
                @Override
                public List<String> load(Key key) throws Exception {
                    return loadAssociatedTag(key.getAppId(), key.getActivityTopicId(), key.getTopN(), key.getTopNType());
                }
            });

    public List<String> getAssociatedTag(Long appId) {
        try {
            DBTimeProfile.enter("getAssociatedTag");
            return cache.get(new Key(appId, null, TOP_COUNT, TagTopNTypeEnum.FINAL_TYPE.getType()));
        } catch (Exception e) {
            throw new RecommendEngineException("loadAssociatedTag error", e);
        } finally {
            DBTimeProfile.release();
        }

    }

    /**
     * 加载关联标签
     *
     * @param appId
     * @param activityTopicId
     * @param topN
     * @param topNType
     * @return
     */
    private List<String> loadAssociatedTag(Long appId, Long activityTopicId, long topN, int topNType) {

        List<AdvertRcmdTagPreferenceTopEntity> advertRcmdTagPreferenceTopEntityList = new ArrayList<>();

        // 参数判断
        if ( appId==null&&activityTopicId==null) {
            logger.warn("getAssociatedTag param cheak invalid appId=null,activityTopicId=null", ResultCodeEnum.PARAMS_INVALID.getDesc());
            return Lists.newArrayList();
        }


        try {

            // 1 get tag by app id  top
            List<AdvertRcmdTagPreferenceTopEntity> appEntityList14 = advertRcmdTagPreferenceTopBo.getTagByAppIdTop(appId,
                    StatTypeEnum.STAT_TYPE_RECENT_14.getIndex(), topN, topNType);
            List<AdvertRcmdTagPreferenceTopEntity> appEntityList180 = advertRcmdTagPreferenceTopBo.getTagByAppIdTop(appId,
                    StatTypeEnum.STAT_TYPE_RECENT_180.getIndex(), topN, topNType);

            if (appEntityList14 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(appEntityList14);
            } else if (appEntityList180 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(appEntityList180);
            }

            // 2 get tag by activity topic id  top
            List<AdvertRcmdTagPreferenceTopEntity> activityTopicEntityList14 =
                    advertRcmdTagPreferenceTopBo.getTagByActivityTopicIdTop(activityTopicId,
                            StatTypeEnum.STAT_TYPE_RECENT_14.getIndex(), topN, topNType);
            List<AdvertRcmdTagPreferenceTopEntity> activityTopicEntityList180 =
                    advertRcmdTagPreferenceTopBo.getTagByActivityTopicIdTop(activityTopicId,
                            StatTypeEnum.STAT_TYPE_RECENT_180.getIndex(), topN, topNType);

            if (activityTopicEntityList14 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(activityTopicEntityList14);
            } else if (activityTopicEntityList180 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(activityTopicEntityList180);
            }

            // 3 get tag by global top
            List<AdvertRcmdTagPreferenceTopEntity> globalEntityList14 =
                    advertRcmdTagPreferenceTopBo.getTagByGlobalTop(StatTypeEnum.STAT_TYPE_RECENT_14.getIndex(), topN, topNType);
            List<AdvertRcmdTagPreferenceTopEntity> globalEntityList180 =
                    advertRcmdTagPreferenceTopBo.getTagByGlobalTop(StatTypeEnum.STAT_TYPE_RECENT_180.getIndex(), topN, topNType);


            if (globalEntityList14 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(globalEntityList14);
            } else if (globalEntityList180 != null) {
                advertRcmdTagPreferenceTopEntityList.addAll(globalEntityList180);
            }


        } catch (Exception e) {
            logger.error("getAssociatedTag happen error", e);
            throw new RecommendEngineException("getAssociatedTag happen error", e);
        }
        return Lists.newArrayList(advertRcmdTagPreferenceTopEntityList.stream().map(AdvertRcmdTagPreferenceTopEntity::getTagId).collect(Collectors.toSet()));
    }


    public List<String> getTagIdList(List<AdvertRcmdTagPreferenceTopEntity> entityList) {

        // 参数判断
        if (CollectionUtils.isEmpty(entityList)) {
            logger.warn("getTagIdList param cheak invalid", ResultCodeEnum.PARAMS_INVALID.getDesc());
            return Collections.emptyList();
        }
        return Lists.newArrayList(entityList.stream().map(AdvertRcmdTagPreferenceTopEntity::getTagId).collect(Collectors.toSet()));
    }

}

class Key {
    Long appId;
    Long activityTopicId;
    long topN;
    int topNType;


    public Key(Long appId, Long activityTopicId, long topN, int topNType) {
        this.appId = appId;
        this.activityTopicId = activityTopicId;
        this.topN = topN;
        this.topNType = topNType;
    }

    public String createKey() {
        StringBuilder sb = new StringBuilder();
        if (appId != null) {
            sb.append(appId);
        }
        sb.append("-");
        if (activityTopicId != null) {
            sb.append(activityTopicId);
        }
        sb.append("-").append(topN).append("-").append(topNType);
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return createKey().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) {
            return false;
        }
        Key key = (Key) obj;
        return createKey().equals(key.createKey());
    }

    public Long getAppId() {
        return appId;
    }

    public Key setAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    public Long getActivityTopicId() {
        return activityTopicId;
    }

    public Key setActivityTopicId(Long activityTopicId) {
        this.activityTopicId = activityTopicId;
        return this;
    }

    public long getTopN() {
        return topN;
    }

    public Key setTopN(long topN) {
        this.topN = topN;
        return this;
    }

    public int getTopNType() {
        return topNType;
    }

    public Key setTopNType(int topNType) {
        this.topNType = topNType;
        return this;
    }
}
